#include <iostream>
#include <pigpio.h>
#include <signal.h>
#include <sys/types.h>
#include <unistd.h>

static void err_handler (int sig) {
    gpioTerminate();
    signal(SIGINT, SIG_DFL);
    kill(getppid(), SIGINT);
    kill(getpid(), SIGINT);
    exit(0);
}

static void exit_handler () {
    gpioTerminate();
}

int starting_f = 8000;
int bitHigher = 25;
int bit2 = 24;
int bit3 = 23;
int bit4 = 18;
int pwmPin = 21;
int divisions[] = {1, 2, 4, 5, 8, 10, 16, 20,
    25, 32, 40, 50, 80, 100, 160, 200};
using namespace std;

int main() {
    if (gpioInitialise() < 0) return 1;
    signal(SIGQUIT, err_handler);
    signal(SIGINT, err_handler);
    signal(SIGTERM, err_handler);
    signal(SIGABRT, err_handler);
    atexit(exit_handler);
    gpioSetMode(bitHigher, PI_INPUT);
    gpioSetMode(bit2, PI_INPUT);
    gpioSetMode(bit3, PI_INPUT);
    gpioSetMode(bit4, PI_INPUT);
    gpioSetPullUpDown(bitHigher, PI_PUD_DOWN);
    gpioSetPullUpDown(bit2, PI_PUD_DOWN);
    gpioSetPullUpDown(bit3, PI_PUD_DOWN);
    gpioSetPullUpDown(bit4, PI_PUD_DOWN);
    gpioSetMode(pwmPin, PI_OUTPUT);
    gpioPWM(pwmPin, 128);
    while(1) {
        int highest = gpioRead(bitHigher);
        int b2 = gpioRead(bit2);
        int b3 = gpioRead(bit3);
        int b4 = gpioRead(bit4);
        int total = highest*8 + b2 * 4 + b3 * 2 + b4;
        gpioSetPWMfrequency(pwmPin, starting_f/divisions[total]);
        cout << "frequency should be " << starting_f/divisions[total];
        time_sleep(1);
    }
}
